%
% Generate Figures 10.15 and 10.17 in the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%
clc
close all
clear all

Vocabulary =[0   0    1.5  3.5  0   0    0.5  2.5 1;
    0.5 2.5  3.5  5.5  1.5 3    3    4.5 0.75;
    2.5 4.5  5.5  7.5  3.5 5    5    6.5 0.75;
    4.5 6.5  7.5  9.5  5.5 7    7    8.5 0.75;
    6.5 8.5  10   10   7.5 9.5  10   10  1];

% Words corresponding to the weights for Tech Merit and Presentation
WordsTP=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]-.5 .75];

% Words corresponding to the weights for the three reviewers
WordsR=[0     0     2.75  5.75   0     0     1.25  4.25 1; % low expertise
    1.25  4.25  5.75  8.75   2.75  5     5     7.25 0.75; %% moderate expertise
    4.25  7.25  10    10     5.75  8.75  10    10   1]; % high expertise

% Weights for the three reviewers
WR=[3 2 1;
    2 2 2
    1 2 3];

%%
Y1T = Vocabulary(4,:);
Y1P = Vocabulary(1,:);
Y1=LWA([Y1T; Y1P],WordsTP);

%%
Y2T = Vocabulary(4,:);
Y2P = Vocabulary(3,:);
Y2=LWA([Y2T; Y2P],WordsTP);

%%
Y3T = Vocabulary(4,:);
Y3P = Vocabulary(5,:);
Y3=LWA([Y3T; Y3P],WordsTP);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
fill([Y1T(1:4) Y1T(8:-1:5)],[0 1 1 0 0 Y1T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
fill([Y1P(1:4) Y1P(8:-1:5)],[0 1 1 0 0 Y1P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y1T(1:4) Y1T(8:-1:5)],[0 1 1 0 0 Y1T([9 9]) 0],'k-');
plot([Y1P(1:4) Y1P(8:-1:5)],[0 1 1 0 0 Y1P([9 9]) 0],'k-');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
set(gca,'YTick',[0:0.25:1]);
set(gca,'XTick',[0:1:10]);
text('Interpreter','latex','String','$$\widetilde{Y}_{1T}$$','Position',...
    [mean(Y1T(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{1P}$$','Position',...
    [mean(Y1P(2:3))-0.3,1.18]);
saveas(gcf,'Fig10-15a.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
fill([Y2T(1:4) Y2T(8:-1:5)],[0 1 1 0 0 Y2T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
fill([Y2P(1:4) Y2P(8:-1:5)],[0 1 1 0 0 Y2P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y2T(1:4) Y2T(8:-1:5)],[0 1 1 0 0 Y2T([9 9]) 0],'k-');
plot([Y2P(1:4) Y2P(8:-1:5)],[0 1 1 0 0 Y2P([9 9]) 0],'k-');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
set(gca,'YTick',[0:0.25:1]);
set(gca,'XTick',[0:1:10]);
text('Interpreter','latex','String','$$\widetilde{Y}_{2T}$$','Position',...
    [mean(Y2T(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{2P}$$','Position',...
    [mean(Y2P(2:3))-0.3,1.18]);
saveas(gcf,'Fig10-15b.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
fill([Y3T(1:4) Y3T(8:-1:5)],[0 1 1 0 0 Y3T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
fill([Y3P(1:4) Y3P(8:-1:5)],[0 1 1 0 0 Y3P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y3T(1:4) Y3T(8:-1:5)],[0 1 1 0 0 Y3T([9 9]) 0],'k-');
plot([Y3P(1:4) Y3P(8:-1:5)],[0 1 1 0 0 Y3P([9 9]) 0],'k-');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
set(gca,'YTick',[0:0.25:1]);
set(gca,'XTick',[0:1:10]);
text('Interpreter','latex','String','$$\widetilde{Y}_{3T}$$','Position',...
    [mean(Y3T(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{3P}$$','Position',...
    [mean(Y3P(2:3))-0.3,1.18]);
saveas(gcf,'Fig10-15c.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
fill([Y1(1:4) Y1(8:-1:5)],[0 1 1 0 0 Y1([9 9]) 0],[0.9 0.9 0.9]);
hold on;
fill([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],[0.9 0.9 0.9]);
fill([Y3(1:4) Y3(8:-1:5)],[0 1 1 0 0 Y3([9 9]) 0],[0.9 0.9 0.9]);
plot([Y1(1:4) Y1(8:-1:5)],[0 1 1 0 0 Y1([9 9]) 0],'k-');
plot([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],'k-');
plot([Y3(1:4) Y3(8:-1:5)],[0 1 1 0 0 Y3([9 9]) 0],'k-');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
set(gca,'YTick',[0:0.25:1]);
set(gca,'XTick',[0:1:10]);
text('Interpreter','latex','String','$$\widetilde{Y}_{R1}$$','Position',...
    [mean(Y1(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{R2}$$','Position',...
    [mean(Y2(2:3))-.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{R3}$$','Position',...
    [mean(Y3(2:3))-.3,1.18]);
saveas(gcf,'Fig10-15d.eps');

numbers1='acegi';
numbers2='bdfhj';
for i=1:3
    YAE=LWA([Y1; Y2; Y3],WordsR(WR(i,:),:));

    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',8);
    set(gcf,'DefaultaxesFontSize',8);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(5.5,2,1)
    for j=1:3
        fill(WordsR(WR(i,j),[1:4 8:-1:5]),[0 1 1 0 0 WordsR(WR(i,j),[9 9]) 0],[0.9 0.9 0.9]);
        hold on;
    end
    for j=1:3
        plot(WordsR(WR(i,j),[1:4 8:-1:5]),[0 1 1 0 0 WordsR(WR(i,j),[9 9]) 0],'k-');
    end
    axis([0 11 0 1.3]);
    box off
    text(11.2,0.02,'w');
    text(0.15,1.25,'u');
    arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
    set(gca,'YTick',[0:0.25:1]);
    set(gca,'XTick',[0:1:10]);
    if i==2
        text('Interpreter','latex','String',...
            '$$\widetilde{W}_1=\widetilde{W}_2=\widetilde{W}_3$$','Position',...
            [mean(WordsR(WR(i,1),2:3))-1.6,1.18]);
    else
        text('Interpreter','latex','String','$$\widetilde{W}_1$$','Position',...
            [mean(WordsR(WR(i,1),2:3))-0.3,1.18]);
        text('Interpreter','latex','String','$$\widetilde{W}_2$$','Position',...
            [mean(WordsR(WR(i,2),2:3))-.3,1.18]);
        text('Interpreter','latex','String','$$\widetilde{W}_3$$','Position',...
            [mean(WordsR(WR(i,3),2:3))-.3,1.18]);
    end
    saveas(gcf,['Fig10-17' numbers1(i) '.eps']);

    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',8);
    set(gcf,'DefaultaxesFontSize',8);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(5.5,2,1)
    fill(YAE([1:4 8:-1:5]),[0 1 1 0 0 YAE([9 9]) 0],[0.9 0.9 0.9]);
    hold on;
    plot(YAE([1:4 8:-1:5]),[0 1 1 0 0 YAE([9 9]) 0],'k-');
    axis([0 11 0 1.3]);
    box off
    text(11.2,0.02,'y');
    text(0.15,1.25,'u');
    arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
    set(gca,'YTick',[0:0.25:1]);
    set(gca,'XTick',[0:1:10]);
    text('Interpreter','latex','String','$$\widetilde{Y}_{AE}$$','Position',...
        [mean(YAE(2:3))-0.3,1.18]);
    saveas(gcf,['Fig10-17' numbers2(i) '.eps']);
end
close all